Option Strict Off
Option Explicit On
Imports VB = Microsoft.VisualBasic
Friend Class ElzedDemoMain
	Inherits System.Windows.Forms.Form
	Public lTextExpression As Integer
	Private dLowMIPS(5) As Double
	Private dHighMIPS(5) As Double
    Private dAvrMIPS(5) As Double

    Private IsInitializingFlag As Boolean
    Public Property IsInitializing() As Boolean
        Get
            Return IsInitializingFlag
        End Get
        Set(ByVal value As Boolean)
            IsInitializingFlag = value
        End Set
    End Property

    Private Sub AllowComplex_CheckStateChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles AllowComplex.CheckStateChanged
        If IsInitializing = False Then
            If AllowComplex.CheckState = 0 Then
                lzSetAllowComplexResults((False))
            Else
                lzSetAllowComplexResults((True))
            End If
        End If
    End Sub

    Private Sub APITest_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles APITest.Click

        VarTest()
        ArrayTest()

    End Sub

    Private Sub Clear_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Clear.Click

        NumResult.Text = ""
        StrResult.Text = ""
        BoolResult.Text = ""
        ErrMsgBox.Text = ""
        ExpBox.Text = ""

    End Sub

    Private Sub Copy_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Copy.Click

        ExpBox.Text = StrResult.Text

    End Sub

    Private Sub Evaluate_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Evaluate.Click
        Dim szResult As String
        Dim bResult As Boolean
        Dim dResult As Double
        Dim dImag As Double
        Dim result As Byte
        Dim resultType As Byte
        Dim szThrowAway As String

        szThrowAway = szTestString.Value

        Dim hExpressionHandle As ULong

        If (Len(ExpBox.Text) > 0) Then

            hExpressionHandle = lzParseExp(ExpBox.Text)

            If (hExpressionHandle > 0) Then

                resultType = lzGetBooleanTrue

                'result = lzEvalExpStr(ExpBox.Text)
                result = lzEvalExpHndl(hExpressionHandle)

                resultType = lzGetLastResultType

                dResult = lzEvalExpStrToComp(ExpBox.Text, dImag)
                dResult = lzEvalExpHndlToComp(hExpressionHandle, dImag)
                dResult = lzGetLastRealResult
                dImag = lzGetLastImagResult

                'dResult = lzEvalExpStrToNum(ExpBox.Text)
                dResult = lzEvalExpHndlToNum(hExpressionHandle)
                dResult = lzGetLastNumResult
                NumResult.Text = CStr(dResult)

                'szResult = lzEvalExpStrToStr(ExpBox.Text)
                szResult = lzEvalExpHndlToStr(hExpressionHandle)
                szResult = lzGetLastStrResult
                StrResult.Text = szResult

                'bResult = lzEvalExpStrToBool(ExpBox.Text)
                bResult = lzEvalExpHndlToBool(hExpressionHandle)
                bResult = lzGetLastBoolResult

                If (bResult) Then
                    BoolResult.Text = "True"
                Else
                    BoolResult.Text = "False"
                End If

                ErrMsgBox.Text = lzGetLastErrorText()

                lzDeleteExp((hExpressionHandle))

            Else
                ErrMsgBox.Text = lzGetLastErrorText()

            End If

        End If

    End Sub

    Private Sub ElzedDemoMain_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
        Dim result As Boolean
        Dim errorCode As Integer
        Dim setting As Byte

        Dim bLinkResult As Boolean

        Dim hObjectHandle As ULong

        'result = lzInitialize("UDTDMGZCQEWBTETKSKYNBJ")
        result = lzInitialize("")
        result = lzClearContext()

        lzSetAllowImpliedMult((False))
        lzSetQuoteMark((kQuoteDouble))
        lzSetRadixMark((kRadixPeriod))

        setting = lzGetBooleanTrue
        lzSetBooleanTrue((kTrueNegOne))
        setting = lzGetBooleanTrue

        lzSetAllowComplexResults((True))
        AllowComplex.CheckState = System.Windows.Forms.CheckState.Checked
        lzSetAngleUnit((kAngleDegrees))
        AngleUnit.SelectedIndex = 0
        lzSetCoordinateFormat((kCoordRect))
        CoordFormat.SelectedIndex = 1
        lzSetOutputBase((kBase10))
        OutputBase.SelectedIndex = 2

        TestExpression.SelectedIndex = 3

        result = lzCreatePrivateContext("VBTest")
        hObjectHandle = lzSetContext("VBTest", False)

        szTestString.Value = "Holy wazoo, Batman!"
        bLinkResult = lzLinkStrVar(kGlobalScope, "testString", szTestString.Value, 255)

        'result = lzSetErrorCallback(AddressOf HandleError)
        result = lzDefineError(kCosmicScope, 10010, "Something wacky this way comes")

        errorCode = lzLinkCallbackOp(kGlobalScope, "MyOperator", kOpPrefix, "boolean", "number, string, boolean", "sin", AddressOf MyExtOperator)
        If (errorCode > 0) Then
            HandleError((errorCode))
        End If

        errorCode = lzLinkCallbackOp(kGlobalScope, "MyOtherOp", kOpPrefix, "number", "2", "sin", AddressOf MyOtherExtOperator)
        If (errorCode > 0) Then
            HandleError((errorCode))
        End If

        errorCode = lzDefineExpOp(kGlobalScope, "xfunc", kOpPrefix, "number", "number x, number y", "sin", vbNullString)
        errorCode = lzDefineExpOpStr(kGlobalScope, "xfunc", "x^y")
        If (errorCode > 0) Then
            HandleError((errorCode))
        End If

        errorCode = lzReadExpOp(kGlobalScope, "yfunc", kOpPrefix, "number", "number x, number y", "sin", vbNullString)
        errorCode = lzReadExpOpStr(kGlobalScope, "yfunc", "yfunc.txt")
        If (errorCode > 0) Then
            HandleError((errorCode))
        End If


    End Sub

    Private Sub ElzedDemoMain_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        Dim result As Boolean

        result = lzDestroyPrivateContext("VBTest")

    End Sub

    Private Sub OutputBase_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles OutputBase.SelectedIndexChanged

        If IsInitializing = False Then

            Select Case OutputBase.Text

                Case "Binary"
                    lzSetOutputBase((kBase2))
                Case "Octal"
                    lzSetOutputBase((kBase8))
                Case "Decimal"
                    lzSetOutputBase((kBase10))
                Case "Duodecimal"
                    lzSetOutputBase((kBase12))
                Case "Hexadecimal"
                    lzSetOutputBase((kBase16))
                Case Else
                    lzSetOutputBase((kBase10))

            End Select

        End If

    End Sub

    Private Sub CoordFormat_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles CoordFormat.SelectedIndexChanged
        If IsInitializing = False Then

            Select Case CoordFormat.Text

                Case "Rectangular"
                    lzSetCoordinateFormat((kCoordRect))
                Case "Polar"
                    lzSetCoordinateFormat((kCoordPolar))
                Case Else
                    lzSetCoordinateFormat((kCoordRect))

            End Select
        End If
    End Sub

    Private Sub AngleUnit_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles AngleUnit.SelectedIndexChanged
        If IsInitializing = False Then

            Select Case CoordFormat.Text

                Case "Degrees"
                    lzSetAngleUnit((kAngleDegrees))
                Case "Radians"
                    lzSetAngleUnit((kAngleRadians))
                Case "Grads"
                    lzSetAngleUnit((kAngleGrads))
                Case Else
                    lzSetAngleUnit((kAngleDegrees))

            End Select
        End If
    End Sub

    Private Sub SpeedTest_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles SpeedTest.Click
        Dim dElapsedTime As Double
        Dim dtEndTime As Double
        Dim dtStartTime As Double

        Dim dFester As Double
        Dim dWazoo As Double
        Dim hContextHandle As ULong
        Dim hExpressionHandle As ULong
        Dim hFesterHandle As ULong
        Dim hWazooHandle As ULong
        Dim dResult As Double
        Dim bBoolResult As Boolean

        Dim lExpressionIndex As Integer
        Dim sExpression As String

        Dim dTests As Double
        Dim TimerStart As Single, TimerEnd As Single
        Dim dMIPS As Double

        MIPS.Text = "MIPS"

        bBoolResult = lzClearContext()
        lzSetInvertArrayIndices((True))

        bBoolResult = lzCreatePrivateContext("Speed Test")
        hContextHandle = lzSetContext("Speed Test", False)

        dFester = 0.0#
        dWazoo = 0.0#

        'bBoolResult = lzLinkNumVar(kGlobalScope, "fester", dFester)
        'bBoolResult = lzLinkNumVar(kGlobalScope, "wazoo", dWazoo)

        'bBoolResult = lzSetNumVar(kGlobalScope, "fester", dFester)
        'bBoolResult = lzSetNumVar(kGlobalScope, "wazoo", dWazoo)

        hFesterHandle = lzCreateNumVar(kGlobalScope, "fester", 0)
        hWazooHandle = lzCreateNumVar(kGlobalScope, "wazoo", 0)

        lExpressionIndex = TestExpression.SelectedIndex

        Select Case TestExpression.SelectedIndex
            Case 0
                sExpression = "fester*2+wazoo*2"
            Case 1
                sExpression = "sin(fester)+sin(wazoo)"
            Case 2
                sExpression = "fester^2+wazoo^2"
            Case 3
                sExpression = "abs(sin(sqrt(fester^2+wazoo^2))*255)"
            Case 4
                sExpression = "abs(sin(sqrt(fester*fester+wazoo*wazoo))*255)"
            Case 5
                sExpression = "(fester^2)+(5*fester)-10"
            Case Else
                sExpression = "abs(sin(sqrt(fester^2+wazoo^2))*255)"
                lExpressionIndex = 3
        End Select

        HighMIPS.Text = CStr(dHighMIPS(lExpressionIndex))
        HighMIPS.Text = HighMIPS.Text & " MIPS"

        LowMIPS.Text = CStr(dLowMIPS(lExpressionIndex))
        LowMIPS.Text = LowMIPS.Text & " MIPS"

        AvrMIPS.Text = CStr(dAvrMIPS(lExpressionIndex))
        AvrMIPS.Text = AvrMIPS.Text & " MIPS"

        MIPSRange.Text = CStr(System.Math.Round(dHighMIPS(lExpressionIndex) - dLowMIPS(lExpressionIndex), 4))
        MIPSRange.Text = MIPSRange.Text & " MIPS"

        hExpressionHandle = lzParseExp(sExpression)

        dTests = 4000000
        dResult = 0.0

        If (hExpressionHandle > 0) Then

            'dtStartTime = GetTickCount
            TimerStart = VB.Timer()

            For dFester = 1 To 2000
                'bBoolResult = lzSetNumVar(kGlobalScope, "fester", dFester)
                bBoolResult = lzSetNumVarByHandle(hFesterHandle, dFester)

                For dWazoo = 1 To 2000
                    'bBoolResult = lzSetNumVar(kGlobalScope, "wazoo", dWazoo)
                    bBoolResult = lzSetNumVarByHandle(hWazooHandle, dWazoo)

                    dResult = dResult + lzEvalExpHndlToNum(hExpressionHandle)
                Next dWazoo
            Next dFester

            'dtEndTime = GetTickCount
            TimerEnd = VB.Timer() - TimerStart

            NumResult.Text = CStr(dResult)
        End If

        dElapsedTime = dtEndTime - dtStartTime
        'dMIPS = System.Math.Round((dTests / (dElapsedTime / 1000)) / 1000000, 4)
        dMIPS = System.Math.Round((dTests / TimerEnd) / 1000000, 4)
        MIPS.Text = CStr(dMIPS)
        MIPS.Text = MIPS.Text & " MIPS"

        If (dMIPS > dHighMIPS(lExpressionIndex)) Then
            dHighMIPS(lExpressionIndex) = dMIPS
            HighMIPS.Text = CStr(dHighMIPS(lExpressionIndex))
            HighMIPS.Text = HighMIPS.Text & " MIPS"
        End If

        If ((dMIPS < dLowMIPS(lExpressionIndex)) Or (dLowMIPS(lExpressionIndex) = 0)) Then
            dLowMIPS(lExpressionIndex) = dMIPS
            LowMIPS.Text = CStr(dLowMIPS(lExpressionIndex))
            LowMIPS.Text = LowMIPS.Text & " MIPS"
        End If

        If ((dMIPS < dLowMIPS(lExpressionIndex)) Or (dLowMIPS(lExpressionIndex) = 0)) Then
            dLowMIPS(lExpressionIndex) = dMIPS
            LowMIPS.Text = CStr(dLowMIPS(lExpressionIndex))
            LowMIPS.Text = LowMIPS.Text & " MIPS"
        End If

        If (dAvrMIPS(lExpressionIndex) > 0) Then
            dAvrMIPS(lExpressionIndex) = System.Math.Round((dAvrMIPS(lExpressionIndex) + dMIPS) / 2, 4)
        Else
            dAvrMIPS(lExpressionIndex) = dMIPS
        End If

        AvrMIPS.Text = CStr(dAvrMIPS(lExpressionIndex))
        AvrMIPS.Text = AvrMIPS.Text & " MIPS"

        MIPSRange.Text = CStr(System.Math.Round(dHighMIPS(lExpressionIndex) - dLowMIPS(lExpressionIndex), 4))
        MIPSRange.Text = MIPSRange.Text & " MIPS"

        bBoolResult = lzDestroyPrivateContext("Speed Test")
        hContextHandle = lzSetContext("VBTest", False)

    End Sub
End Class